use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

// Rename 'instructors' to 'instructor_ids' if the 'instructors' column exists
if (Schema::hasColumn('courses', 'instructors')) {
    Schema::table('courses', function (Blueprint $table) {
        $table->renameColumn('instructors', 'instructor_ids');
    });
}

//Add new columns
if (!Schema::hasColumn('users', 'educations')) {
    Schema::table('users', function(Blueprint $table) {
        $table->longText('educations')->nullable();
    });
}

if (!Schema::hasColumn('users', 'video_url')) {
    Schema::table('users', function(Blueprint $table) {
        $table->string('video_url')->nullable();
    });
}

if (!Schema::hasColumn('courses', 'enable_drip_content')) {
    Schema::table('courses', function(Blueprint $table) {
        $table->integer('enable_drip_content')->nullable();
    });
}

if (!Schema::hasColumn('courses', 'drip_content_settings')) {
    Schema::table('courses', function(Blueprint $table) {
        $table->longText('drip_content_settings')->nullable();
    });
}

\DB::table('courses')->where('id', '>', 0)->update(['enable_drip_content' => 0, 'drip_content_settings' => '{"lesson_completion_role":"percentage","minimum_duration":15,"minimum_percentage":"30","locked_lesson_message":"&lt;h3 xss=&quot;removed&quot; style=&quot;text-align: center; &quot;&gt;&lt;span xss=&quot;removed&quot;&gt;&lt;strong&gt;Permission denied!&lt;\/strong&gt;&lt;\/span&gt;&lt;\/h3&gt;&lt;p xss=&quot;removed&quot; style=&quot;text-align: center; &quot;&gt;&lt;span xss=&quot;removed&quot;&gt;This course supports drip content, so you must complete the previous lessons.&lt;\/span&gt;&lt;\/p&gt;"}']);

if (!Schema::hasColumn('seo_fields', 'bootcamp_id')) {
    Schema::table('seo_fields', function(Blueprint $table) {
        $table->integer('bootcamp_id')->nullable();
    });
}

if (!Schema::hasColumn('watch_histories', 'course_progress')) {
    Schema::table('watch_histories', function(Blueprint $table) {
        $table->integer('course_progress')->nullable();
    });
}

if (!Schema::hasColumn('watch_durations', 'watched_student_id')) {
    Schema::table('watch_durations', function(Blueprint $table) {
        $table->integer('watched_student_id')->nullable();
    });
}

if (!Schema::hasColumn('watch_durations', 'watched_course_id')) {
    Schema::table('watch_durations', function(Blueprint $table) {
        $table->integer('watched_course_id')->nullable();
    });
}

if (!Schema::hasColumn('watch_durations', 'watched_lesson_id')) {
    Schema::table('watch_durations', function(Blueprint $table) {
        $table->integer('watched_lesson_id')->nullable();
    });
}

if (!Schema::hasColumn('watch_durations', 'current_duration')) {
    Schema::table('watch_durations', function(Blueprint $table) {
        $table->integer('current_duration')->nullable();
    });
}

if (!Schema::hasColumn('watch_durations', 'watched_counter')) {
    Schema::table('watch_durations', function(Blueprint $table) {
        $table->longText('watched_counter')->nullable();
    });
}